/*
 * Decompiled with CFR 0.152.
 */
package com.chronapp.porter.client.connection;

import com.chronapp.porter.client.auth.TokenExtractor;
import com.chronapp.porter.client.connection.ResponseData;
import com.chronapp.porter.client.connection.RestApiDownloader;
import com.chronapp.porter.common.ChronappException;
import com.chronapp.porter.common.Row;
import com.chronapp.porter.config.ClientConfig;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class PorterAPIClient {
    private static final Logger LOGGER = Logger.getLogger(PorterAPIClient.class);
    private static final String DESCRIPTION = "description";
    private static final int MAX_RETRIES_PER_APICALL = 3;
    private static final long STATE_POLLING_SLEEP_MIN = 2000L;
    private static final long STATE_POLLING_SLEEP_MAX = 300000L;
    private static final double STATE_POLLING_SLEEP_DELAY = 2.0;
    private static final long STATE_POLLING_TIMEOUT = 7500000L;
    private static final long SLEEP_BEFORE_RETRY = 90000L;
    public static final String ERROR_MESSAGE = "errorMessage";
    public static final String LOG_ID = "logId";
    private final ClientConfig config;
    private final TokenExtractor tokenExtractor;
    private int currentTryRun;

    public PorterAPIClient(ClientConfig config) {
        this.config = config;
        this.tokenExtractor = new TokenExtractor(config.getTenant(), config.getSso());
    }

    public void begin(UUID uuid, String description) {
        Map<String, String> data = Map.of(DESCRIPTION, description);
        String startEndpoint = "/process/start/" + String.valueOf(uuid);
        this.runWithClient(uuid, startEndpoint, target -> target.request().accept(MediaType.APPLICATION_JSON_TYPE).post(Entity.json(data)));
    }

    public void end(UUID uuid, String description) {
        String startEndpoint = "/process/end/" + String.valueOf(uuid);
        Map<String, String> data = Map.of(DESCRIPTION, description);
        this.runWithClient(uuid, startEndpoint, target -> target.request().accept(MediaType.APPLICATION_JSON_TYPE).put(Entity.json(data)));
    }

    public void truncate(String endpoint, UUID uuid, String description) {
        String startEndpoint = "/upload/" + endpoint + "/truncate?uuid=" + String.valueOf(uuid);
        Map<String, String> data = Map.of(DESCRIPTION, description);
        this.runWithClient(uuid, startEndpoint, target -> target.request().accept(MediaType.APPLICATION_JSON_TYPE).post(Entity.json(data)));
    }

    public void upload(String endpoint, UUID uuid, List<Row> data) {
        String uploadEndpoint = "/upload/" + endpoint + "?uuid=" + String.valueOf(uuid);
        this.runWithClient(uuid, uploadEndpoint, target -> target.request().accept(MediaType.APPLICATION_JSON_TYPE).post(Entity.json(data)));
    }

    public RestApiDownloader.DownloadResponse download(String api, Integer offset, Integer max, UUID uuid) {
        AtomicReference res = new AtomicReference();
        String downloadEndpoint = "/download/" + api + "?offset=" + offset + "&max=" + max + "&uuid=" + String.valueOf(uuid);
        this.runWithClient(uuid, downloadEndpoint, target -> {
            Response response = target.request().accept(MediaType.APPLICATION_JSON_TYPE).get();
            List<Row> rows = response.readEntity(new GenericType<List<Row>>(this){});
            int totalCount = Integer.parseInt(response.getHeaders().getFirst("X-count").toString());
            BigInteger logId = PorterAPIClient.getLogIdFromResponse(response);
            res.set(new RestApiDownloader.DownloadResponse(rows, totalCount, logId));
            return response;
        });
        return (RestApiDownloader.DownloadResponse)res.get();
    }

    public void exceptions(UUID uuid, String description, String e, BigInteger logId) {
        String startEndpoint = "/process/exceptions/" + String.valueOf(uuid);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(DESCRIPTION, description);
        data.put(ERROR_MESSAGE, e);
        data.put(LOG_ID, logId);
        this.runWithClient(uuid, startEndpoint, target -> target.request().accept(MediaType.APPLICATION_JSON_TYPE).put(Entity.json(data)));
    }

    public void updateImport(String endpoint, UUID uuid, String variant) {
        this.processDataInBackend(endpoint, uuid, variant, "import");
    }

    public void updateExport(String endpoint, UUID uuid, String variant) {
        this.processDataInBackend(endpoint, uuid, variant, "export");
    }

    private void processDataInBackend(String endpoint, UUID uuid, String variant, String type) {
        Map<String, String> data = Map.of("variant", variant);
        String processEndpoint = "/process/" + type + "/" + endpoint + "?uuid=" + String.valueOf(uuid);
        ResponseData<BigInteger> r = this.runWithClient(uuid, processEndpoint, target -> target.request().accept(MediaType.APPLICATION_JSON_TYPE).put(Entity.json(data)), BigInteger.class, false);
        if (Response.Status.ACCEPTED.getStatusCode() == r.getStatus()) {
            BigInteger id = r.getEntity();
            this.checkStatusRegularly(uuid, type, endpoint, id);
        }
    }

    private void checkStatusRegularly(UUID uuid, String type, String endpoint, BigInteger id) {
        boolean processRunning = true;
        String processName = "Process " + type + ", " + endpoint;
        long startTime = System.currentTimeMillis();
        long sleepTime = 2000L;
        block9: while (processRunning) {
            String processStatusEndpoint = "/process/status/" + String.valueOf(id);
            ResponseData<String> r = this.runWithClient(uuid, processStatusEndpoint, target -> target.request().accept(MediaType.APPLICATION_JSON_TYPE).get(), String.class, false);
            switch (r.getEntity()) {
                case "failed": {
                    LOGGER.error(processName + " failed");
                    throw new ChronappException(processName + " failed", uuid, this.config.getDescription());
                }
                case "success": {
                    processRunning = false;
                    LOGGER.info(processName + " finished successfully");
                    continue block9;
                }
            }
            LOGGER.info(processName + " still running");
            PorterAPIClient.stopTryingToPoll(startTime, processName, uuid, this.config.getDescription());
            sleepTime = PorterAPIClient.sleepBeforeNextPoll(sleepTime, processName);
        }
    }

    private static long sleepBeforeNextPoll(long sleepTime, String processName) {
        try {
            Thread.sleep(sleepTime);
            sleepTime = (long)Math.min((double)sleepTime * 2.0, 300000.0);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)(processName + " thread could not sleep. singing a lullaby did not help neither.."), e);
            Thread.currentThread().interrupt();
        }
        return sleepTime;
    }

    private static void stopTryingToPoll(long startTime, String processName, UUID uuid, String description) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - startTime > 7500000L) {
            LOGGER.error(processName + " is being canceled. Max timeout limit reached");
            throw new ChronappException(processName + " is being canceled. Max timeout limit reached", uuid, description);
        }
    }

    private void runWithClient(UUID clientCallId, String endpoint, Function<WebTarget, Response> func) {
        this.runWithClient(clientCallId, endpoint, func, null, false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> ResponseData<T> runWithClient(UUID clientCallId, String endpoint, Function<WebTarget, Response> func, Class<T> entityClass, Boolean forceRefresh) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        try (Client client = clientBuilder.build();){
            Response r;
            block19: {
                WebTarget target = client.target(this.config.getUrl() + "/" + this.config.getTenant() + "/" + endpoint);
                this.tokenExtractor.refreshTokenIfNeeded(forceRefresh);
                target.register(this.tokenExtractor);
                r = func.apply(target);
                try {
                    if (r.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) break block19;
                    ResponseData<T> responseData = this.retryOrGiveup(clientCallId, endpoint, func, r, entityClass);
                    if (r != null) {
                        r.close();
                    }
                    return responseData;
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            this.currentTryRun = 0;
            ResponseData<T> responseData = this.getResponseData(entityClass, r);
            if (r != null) {
                r.close();
            }
            return responseData;
        }
        catch (ChronappException e) {
            throw new ChronappException("Could not call endpoint " + endpoint, e, clientCallId, this.config.getDescription(), e.getLogId());
        }
        catch (ProcessingException | IllegalStateException e) {
            throw new ChronappException("Could not call endpoint " + endpoint, e, clientCallId, this.config.getDescription(), null);
        }
    }

    private <T> ResponseData<T> getResponseData(Class<T> entityClass, Response r) {
        ResponseData<T> rd = new ResponseData<T>();
        if (entityClass != null) {
            rd.setEntity(r.readEntity(entityClass));
        }
        rd.setStatus(r.getStatus());
        return rd;
    }

    private <T> ResponseData<T> retryOrGiveup(UUID clientCallId, String endpoint, Function<WebTarget, Response> func, Response r, Class<T> entityClass) {
        LOGGER.warnf("Could not call endpoint %s successfully.\n Statuscode: %d\n, Reason: %s\n", (Object)endpoint, (Object)r.getStatus(), (Object)r.getStatusInfo().toString());
        LOGGER.warnf("Token:\n %s\n", (Object)this.tokenExtractor.getToken());
        if (this.currentTryRun < 3) {
            ++this.currentTryRun;
            LOGGER.warnf("Retrying.. %d/%d", (Object)this.currentTryRun, (Object)3);
            try {
                Thread.sleep(90000L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Could not sleep for retry. singing a lullaby did not help neither..", e);
                Thread.currentThread().interrupt();
            }
            return this.runWithClient(clientCallId, endpoint, func, entityClass, true);
        }
        String message = "Giving up to call endpoint " + endpoint + ". Details: " + r.readEntity(String.class);
        BigInteger logId = PorterAPIClient.getLogIdFromResponse(r);
        throw new ChronappException(message, new Throwable(message), clientCallId, this.config.getDescription(), logId);
    }

    private static BigInteger getLogIdFromResponse(Response r) {
        return Optional.ofNullable(r.getHeaders().getFirst(LOG_ID)).map(String::valueOf).filter(responseLogId -> !responseLogId.isBlank()).map(responseLogId -> {
            try {
                return new BigInteger((String)responseLogId);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"Could not parse logId from response header", e);
                return null;
            }
        }).orElse(null);
    }
}

