/*
 * Decompiled with CFR 0.152.
 */
package com.chronapp.porter.download;

import com.chronapp.porter.common.ChronappException;
import com.chronapp.porter.common.Row;
import com.chronapp.porter.config.ClientConfig;
import com.chronapp.porter.config.DownloadColumn;
import com.chronapp.porter.config.DownloadTableNameColumns;
import com.chronapp.porter.download.DownloadDataHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DbDownloader
implements DownloadDataHandler {
    private static final int MAX = 9;
    private static final int MIN = 0;
    private final ClientConfig config;
    private final DownloadTableNameColumns table;
    private final UUID clientCallId;

    public DbDownloader(ClientConfig config, UUID clientCallId, DownloadTableNameColumns table) {
        this.config = config;
        this.table = table;
        this.clientCallId = clientCallId;
    }

    @Override
    public void truncate() {
        if (DbDownloader.checkTable(this.table.getName())) {
            try (Connection connection = DriverManager.getConnection(this.config.getJdbcurl());
                 PreparedStatement pstmt = connection.prepareStatement(this.getTruncateQuery());){
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (SQLException ex) {
                throw new ChronappException("2: DbDownloader could not truncate Data", ex, this.clientCallId, this.config.getDescription(), null);
            }
        }
    }

    @Override
    public void handle(Iterable<Row> rows, BigInteger logId) {
        try (Connection connection = DriverManager.getConnection(this.config.getJdbcurl());
             PreparedStatement pstmt = connection.prepareStatement(this.createQuery());){
            connection.setAutoCommit(false);
            for (Row row : rows) {
                row.columns().forEach((k, v) -> {
                    try {
                        this.createBatchStatement((String)k, (String)v, pstmt);
                    }
                    catch (SQLException ex) {
                        throw new ChronappException("1: DbDownloader could not insert Data", ex, this.clientCallId, this.config.getDescription(), logId);
                    }
                });
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            connection.commit();
        }
        catch (SQLException ex) {
            throw new ChronappException("2: DbDownloader could not insert Data", ex, this.clientCallId, this.config.getDescription(), logId);
        }
    }

    private String createQuery() {
        return "INSERT INTO " + this.table.getName() + " " + this.getKeys() + " VALUES " + this.getValuePlaceholder();
    }

    private String getTruncateQuery() {
        return "TRUNCATE TABLE " + this.table.getName() + ";";
    }

    private static boolean checkTable(String tableName) {
        return tableName.toLowerCase(Locale.ROOT).startsWith("e_");
    }

    private String getKeys() {
        return this.getSortedKeys().map(DownloadColumn::getDb).collect(Collectors.joining(",", "(", ")"));
    }

    private String getValuePlaceholder() {
        return Collections.nCopies(this.table.getColumns().size(), "?").stream().collect(Collectors.joining(",", "(", ")"));
    }

    private void createBatchStatement(String k, String v, PreparedStatement pstmt) throws SQLException {
        AbstractMap.SimpleImmutableEntry<Integer, DownloadColumn> col = this.getColumn(k);
        if (col != null) {
            int idx = col.getKey();
            if (v == null || v.isEmpty()) {
                pstmt.setObject(idx, null);
            } else {
                switch (col.getValue().getType().toLowerCase(Locale.GERMAN)) {
                    case "decimal": {
                        pstmt.setBigDecimal(idx, new BigDecimal(v));
                        break;
                    }
                    case "boolean": {
                        pstmt.setBoolean(idx, Boolean.parseBoolean(v));
                        break;
                    }
                    case "date": {
                        pstmt.setDate(idx, Date.valueOf(LocalDate.parse(v, DateTimeFormatter.ISO_LOCAL_DATE)));
                        break;
                    }
                    case "time": {
                        pstmt.setTimestamp(idx, Timestamp.valueOf(DbDownloader.getLocalDateTime(v)));
                        break;
                    }
                    case "integer": {
                        pstmt.setInt(idx, Integer.parseInt(v));
                        break;
                    }
                    case "tinyint": {
                        pstmt.setInt(idx, DbDownloader.convertBooleanToBit(v));
                        break;
                    }
                    default: {
                        pstmt.setString(idx, v);
                    }
                }
            }
        }
    }

    private static LocalDateTime getLocalDateTime(String v) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 9, true).toFormatter();
        return LocalDateTime.parse(v, formatter);
    }

    private static int convertBooleanToBit(String v) {
        if ("t".equals(v)) {
            return 1;
        }
        return 0;
    }

    private AbstractMap.SimpleImmutableEntry<Integer, DownloadColumn> getColumn(String name) {
        List<DownloadColumn> keys = this.getSortedKeys().toList();
        int idx = 1;
        for (DownloadColumn key : keys) {
            if (key.getApi().equalsIgnoreCase(name)) {
                return new AbstractMap.SimpleImmutableEntry<Integer, DownloadColumn>(idx, key);
            }
            ++idx;
        }
        return null;
    }

    private Stream<DownloadColumn> getSortedKeys() {
        return this.table.getColumns().stream().sorted();
    }
}

