/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.net.URI;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.spi.ClientConfigProvider;
import org.jboss.resteasy.util.BasicAuthHelper;

public class ClientConfigProviderFilter
implements ClientRequestFilter {
    private final ClientConfigProvider clientConfigProvider;

    public ClientConfigProviderFilter(ClientConfigProvider clientConfigProvider) {
        this.clientConfigProvider = clientConfigProvider;
    }

    @Override
    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.getHeaderString("Authorization") == null) {
            URI uri = requestContext.getUri();
            if (uri == null) {
                LogMessages.LOGGER.warn(Messages.MESSAGES.unableToLoadClientConfigProviderConfiguration());
                return;
            }
            String token = this.clientConfigProvider.getBearerToken(uri);
            if (token != null) {
                requestContext.getHeaders().putSingle("Authorization", "Bearer " + token);
            } else {
                String username = this.clientConfigProvider.getUsername(uri);
                String password = this.clientConfigProvider.getPassword(uri);
                if (username != null && password != null) {
                    requestContext.getHeaders().putSingle("Authorization", BasicAuthHelper.createHeader(username, password));
                }
            }
        }
    }
}

