/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.core.CompletionStageHolder;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.sse.SseImpl;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.util.Types;

public class ContextParameterInjector
implements ValueInjector {
    private static final Constructor<?> constructor;
    private Class<?> rawType;
    private Class<?> proxy;
    private ResteasyProviderFactory factory;
    private Type genericType;
    private Annotation[] annotations;
    private volatile boolean outputStreamWasWritten = false;

    public ContextParameterInjector(Class<?> proxy, Class<?> rawType, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.rawType = rawType;
        this.genericType = genericType;
        this.proxy = proxy;
        this.factory = factory;
        this.annotations = annotations;
    }

    @Override
    public Object inject(HttpRequest request, HttpResponse response, boolean unwrapAsync) {
        if (this.rawType.equals(Providers.class)) {
            return this.factory;
        }
        if (!this.rawType.isInterface() || this.rawType.equals(SseEventSink.class) || ContextParameterInjector.hasAsyncContextData(this.factory, this.genericType)) {
            return this.unwrapIfRequired(request, this.factory.getContextData(this.rawType, this.genericType, this.annotations, unwrapAsync), unwrapAsync);
        }
        if (this.rawType.equals(Sse.class)) {
            return new SseImpl();
        }
        if (this.rawType == CompletionStage.class) {
            return new CompletionStageHolder((CompletionStage)this.createProxy());
        }
        return this.createProxy();
    }

    private static boolean hasAsyncContextData(ResteasyProviderFactory factory, Type genericType) {
        return factory.getAsyncContextInjectors().containsKey(Types.boxPrimitives(genericType));
    }

    private Object unwrapIfRequired(HttpRequest request, Object contextData, boolean unwrapAsync) {
        if (unwrapAsync && this.rawType != CompletionStage.class && contextData instanceof CompletionStage) {
            boolean resolved;
            if (request != null && !(resolved = ((CompletionStage)contextData).toCompletableFuture().isDone())) {
                if (!request.getAsyncContext().isSuspended()) {
                    request.getAsyncContext().suspend();
                }
                Map<Class<?>, Object> contextDataMap = ResteasyContext.getContextDataMap();
                return ((CompletionStage)contextData).thenApply(value -> {
                    ResteasyContext.pushContextDataMap(contextDataMap);
                    return value;
                });
            }
            return (CompletionStage)contextData;
        }
        if (this.rawType == CompletionStage.class && contextData instanceof CompletionStage) {
            return new CompletionStageHolder((CompletionStage)contextData);
        }
        if (!unwrapAsync && this.rawType != CompletionStage.class && contextData instanceof CompletionStage) {
            throw new LoggableFailure(Messages.MESSAGES.shouldBeUnreachable());
        }
        return contextData;
    }

    @Override
    public Object inject(boolean unwrapAsync) {
        if (this.rawType.equals(Application.class) || this.rawType.equals(SseEventSink.class) || ContextParameterInjector.hasAsyncContextData(this.factory, this.genericType)) {
            return this.factory.getContextData(this.rawType, this.genericType, this.annotations, unwrapAsync);
        }
        if (this.rawType.equals(Sse.class)) {
            return new SseImpl();
        }
        if (!this.rawType.isInterface()) {
            Object delegate = this.factory.getContextData(this.rawType, this.genericType, this.annotations, unwrapAsync);
            if (delegate != null) {
                return this.unwrapIfRequired(null, delegate, unwrapAsync);
            }
            throw new RuntimeException(Messages.MESSAGES.illegalToInjectNonInterfaceType());
        }
        if (this.rawType == CompletionStage.class) {
            return new CompletionStageHolder((CompletionStage)this.createProxy());
        }
        return this.createProxy();
    }

    protected Object createProxy() {
        if (this.proxy != null) {
            try {
                return this.proxy.getConstructors()[0].newInstance(new GenericDelegatingProxy());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Object delegate = this.factory.getContextData(this.rawType, this.genericType, this.annotations, false);
        Class<?>[] intfs = this.computeInterfaces(delegate, this.rawType);
        ClassLoader clazzLoader = null;
        ClassLoader classLoader = clazzLoader = delegate == null ? this.rawType.getClassLoader() : delegate.getClass().getClassLoader();
        if (clazzLoader == null) {
            clazzLoader = Thread.currentThread().getContextClassLoader();
        }
        return Proxy.newProxyInstance(clazzLoader, intfs, (InvocationHandler)new GenericDelegatingProxy());
    }

    protected Class<?>[] computeInterfaces(Object delegate, Class<?> cls) {
        ResteasyDeployment deployment = ResteasyContext.getContextData(ResteasyDeployment.class);
        if (deployment != null && Boolean.TRUE.equals(deployment.getProperty("resteasy.proxy.implement.all.interfaces"))) {
            HashSet set = new HashSet();
            set.add(cls);
            if (delegate != null) {
                for (Class<?> delegateClass = delegate.getClass(); delegateClass != null; delegateClass = delegateClass.getSuperclass()) {
                    for (Class<?> intf : delegateClass.getInterfaces()) {
                        set.add(intf);
                        for (Class<?> superIntf : intf.getInterfaces()) {
                            set.add(superIntf);
                        }
                    }
                }
            }
            return set.toArray(new Class[0]);
        }
        return new Class[]{cls};
    }

    OutputStream wrapServletOutputStream(OutputStream os) {
        if (constructor != null) {
            try {
                return (OutputStream)constructor.newInstance(this, os);
            }
            catch (Exception e) {
                return os;
            }
        }
        return os;
    }

    boolean isOutputStreamWasWritten() {
        return this.outputStreamWasWritten;
    }

    void setOutputStreamWasWritten(boolean outputStreamWasWritten) {
        this.outputStreamWasWritten = outputStreamWasWritten;
    }

    static {
        Constructor<?> c;
        try {
            Class.forName("jakarta.servlet.http.HttpServletResponse", false, Thread.currentThread().getContextClassLoader());
            Class<?> clazz = Class.forName("org.jboss.resteasy.core.ContextServletOutputStream");
            c = clazz.getDeclaredConstructor(ContextParameterInjector.class, OutputStream.class);
        }
        catch (Exception ignore) {
            c = null;
        }
        constructor = c;
    }

    private class GenericDelegatingProxy
    implements InvocationHandler {
        private GenericDelegatingProxy() {
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            try {
                Object delegate = ContextParameterInjector.this.factory.getContextData(ContextParameterInjector.this.rawType, ContextParameterInjector.this.genericType, ContextParameterInjector.this.annotations, false);
                if (delegate == null) {
                    String name = method.getName();
                    if (o instanceof ResourceInfo && ("getResourceMethod".equals(name) || "getResourceClass".equals(name))) {
                        return null;
                    }
                    if ("getContextResolver".equals(name)) {
                        return method.invoke((Object)ContextParameterInjector.this.factory, objects);
                    }
                    throw new LoggableFailure(Messages.MESSAGES.unableToFindContextualData(ContextParameterInjector.this.rawType.getName()));
                }
                if ("jakarta.servlet.http.HttpServletResponse".equals(ContextParameterInjector.this.rawType.getName()) && "getOutputStream".equals(method.getName())) {
                    OutputStream sos = (OutputStream)method.invoke(delegate, objects);
                    return ContextParameterInjector.this.wrapServletOutputStream(sos);
                }
                return method.invoke(delegate, objects);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

