/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.interception.jaxrs.ContainerRequestFilterRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.ContainerResponseFilterRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.ReaderInterceptorRegistryImpl;
import org.jboss.resteasy.core.interception.jaxrs.WriterInterceptorRegistryImpl;
import org.jboss.resteasy.core.providerfactory.CommonProviders;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.core.providerfactory.SortedKey;
import org.jboss.resteasy.core.providerfactory.Utils;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.spi.util.Types;

public class ServerHelper
extends CommonProviders {
    protected boolean attachedRequestFilters;
    protected JaxrsInterceptorRegistry<ContainerRequestFilter> requestFilters;
    protected boolean attachedResponseFilters;
    protected JaxrsInterceptorRegistry<ContainerResponseFilter> responseFilters;
    protected boolean attachedAsyncResponseProviders;
    protected Map<Class<?>, AsyncResponseProvider> asyncResponseProviders;
    protected boolean attachedAsyncStreamProviders;
    protected Map<Class<?>, AsyncStreamProvider> asyncStreamProviders;
    protected boolean attachedExceptionMappers;
    protected Map<Class<?>, SortedKey<ExceptionMapper>> exceptionMappers;

    public ServerHelper() {
    }

    public ServerHelper(ResteasyProviderFactoryImpl rpf) {
        super(rpf);
        this.requestFilters = new ContainerRequestFilterRegistryImpl(rpf);
        this.responseFilters = new ContainerResponseFilterRegistryImpl(rpf);
        this.writerInterceptorRegistry = new WriterInterceptorRegistryImpl(rpf);
        this.readerInterceptorRegistry = new ReaderInterceptorRegistryImpl(rpf);
    }

    @Override
    protected JaxrsInterceptorRegistry<ReaderInterceptor> getReaderInterceptorRegistryForWrite() {
        if (this.readerInterceptorRegistry == null) {
            return new ReaderInterceptorRegistryImpl(this.rpf);
        }
        if (this.attachedReaderInterceptors) {
            return this.readerInterceptorRegistry.clone(this.rpf);
        }
        return this.readerInterceptorRegistry;
    }

    @Override
    protected JaxrsInterceptorRegistry<WriterInterceptor> getWriterInterceptorRegistryForWrite() {
        if (this.writerInterceptorRegistry == null) {
            return new WriterInterceptorRegistryImpl(this.rpf);
        }
        if (this.attachedWriterInterceptors) {
            return this.writerInterceptorRegistry.clone(this.rpf);
        }
        return this.writerInterceptorRegistry;
    }

    @Override
    protected MediaTypeMap<SortedKey<MessageBodyReader>> getMessageBodyReadersForWrite() {
        if (this.messageBodyReaders == null) {
            return new MediaTypeMap<SortedKey<MessageBodyReader>>();
        }
        if (this.attachedMessageBodyReaders) {
            return new MediaTypeMap<SortedKey<MessageBodyReader>>(this.messageBodyReaders);
        }
        return this.messageBodyReaders;
    }

    @Override
    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getMessageBodyWritersForWrite() {
        if (this.messageBodyWriters == null) {
            return new MediaTypeMap<SortedKey<MessageBodyWriter>>();
        }
        if (this.attachedMessageBodyWriters) {
            return new MediaTypeMap<SortedKey<MessageBodyWriter>>(this.messageBodyWriters);
        }
        return this.messageBodyWriters;
    }

    public ServerHelper(ResteasyProviderFactoryImpl rpf, ServerHelper parent) {
        super(rpf, parent);
        if (parent.requestFilters != null) {
            this.attachedRequestFilters = true;
            this.requestFilters = parent.requestFilters;
        }
        if (parent.responseFilters != null) {
            this.attachedResponseFilters = true;
            this.responseFilters = parent.responseFilters;
        }
        if (parent.asyncResponseProviders != null) {
            this.attachedAsyncResponseProviders = true;
            this.asyncResponseProviders = parent.asyncResponseProviders;
        }
        if (parent.asyncStreamProviders != null) {
            this.attachedAsyncStreamProviders = true;
            this.asyncStreamProviders = parent.asyncStreamProviders;
        }
        if (parent.exceptionMappers != null) {
            this.attachedExceptionMappers = true;
            this.exceptionMappers = parent.exceptionMappers;
        }
    }

    @Override
    protected void processProviderContracts(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts, Map<Class<?>, Integer> newContracts) {
        int priority;
        ConstrainedTo constrainedTo = provider.getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null && constrainedTo.value() != RuntimeType.SERVER) {
            return;
        }
        super.processProviderContracts(provider, priorityOverride, isBuiltin, contracts, newContracts);
        if (Utils.isA(provider, ContainerRequestFilter.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, ContainerRequestFilter.class, provider);
            this.addContainerRequestFilter(provider, priority);
            newContracts.put(ContainerRequestFilter.class, priority);
        }
        if (Utils.isA(provider, ContainerResponseFilter.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, ContainerResponseFilter.class, provider);
            this.addContainerResponseFilter(provider, priority);
            newContracts.put(ContainerResponseFilter.class, priority);
        }
        if (Utils.isA(provider, AsyncResponseProvider.class, contracts)) {
            try {
                this.addAsyncResponseProvider(provider);
                newContracts.put(AsyncResponseProvider.class, Utils.getPriority(priorityOverride, contracts, AsyncResponseProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncResponseProvider(), e);
            }
        }
        if (Utils.isA(provider, AsyncStreamProvider.class, contracts)) {
            try {
                this.addAsyncStreamProvider(provider);
                newContracts.put(AsyncStreamProvider.class, Utils.getPriority(priorityOverride, contracts, AsyncStreamProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncStreamProvider(), e);
            }
        }
        if (Utils.isA(provider, ExceptionMapper.class, contracts)) {
            try {
                this.addExceptionMapper(provider, isBuiltin);
                newContracts.put(ExceptionMapper.class, Utils.getPriority(priorityOverride, contracts, ExceptionMapper.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateExceptionMapper(), e);
            }
        }
    }

    public void addExceptionMapper(Class provider, boolean isBuiltin) {
        this.addExceptionMapper((ExceptionMapper)this.rpf.createProviderInstance(provider), provider, isBuiltin);
    }

    public void addAsyncStreamProvider(Class provider) {
        this.addAsyncStreamProvider((AsyncStreamProvider)this.rpf.createProviderInstance(provider), provider);
    }

    public void addAsyncResponseProvider(Class provider) {
        AsyncResponseProvider providerInstance = (AsyncResponseProvider)this.rpf.createProviderInstance(provider);
        this.addAsyncResponseProvider(providerInstance, provider);
    }

    public void addContainerResponseFilter(Class provider, int priority) {
        JaxrsInterceptorRegistry<ContainerResponseFilter> registry = this.getResponseFiltersForWrite();
        registry.registerClass(provider, priority);
        this.attachedResponseFilters = false;
        this.responseFilters = registry;
    }

    public void addContainerRequestFilter(Class provider, int priority) {
        JaxrsInterceptorRegistry<ContainerRequestFilter> registry = this.getRequestFiltersForWrite();
        registry.registerClass(provider, priority);
        this.attachedRequestFilters = false;
        this.requestFilters = registry;
    }

    @Override
    protected void processProviderInstanceContracts(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn, Map<Class<?>, Integer> newContracts) {
        JaxrsInterceptorRegistry<Object> registry;
        int priority;
        ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null && constrainedTo.value() != RuntimeType.SERVER) {
            return;
        }
        super.processProviderInstanceContracts(provider, contracts, priorityOverride, builtIn, newContracts);
        if (Utils.isA(provider, ContainerRequestFilter.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, ContainerRequestFilter.class, provider.getClass());
            registry = this.getRequestFiltersForWrite();
            registry.registerSingleton((ContainerRequestFilter)provider, priority);
            this.attachedRequestFilters = false;
            this.requestFilters = registry;
            newContracts.put(ContainerRequestFilter.class, priority);
        }
        if (Utils.isA(provider, ContainerResponseFilter.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, ContainerResponseFilter.class, provider.getClass());
            registry = this.getResponseFiltersForWrite();
            registry.registerSingleton((ContainerRequestFilter)((Object)((ContainerResponseFilter)provider)), priority);
            this.attachedResponseFilters = false;
            this.responseFilters = registry;
            newContracts.put(ContainerResponseFilter.class, priority);
        }
        if (Utils.isA(provider, AsyncResponseProvider.class, contracts)) {
            try {
                this.addAsyncResponseProvider((AsyncResponseProvider)provider, provider.getClass());
                priority = Utils.getPriority(priorityOverride, contracts, AsyncResponseProvider.class, provider.getClass());
                newContracts.put(AsyncResponseProvider.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncResponseProvider(), e);
            }
        }
        if (Utils.isA(provider, AsyncStreamProvider.class, contracts)) {
            try {
                this.addAsyncStreamProvider((AsyncStreamProvider)provider, provider.getClass());
                priority = Utils.getPriority(priorityOverride, contracts, AsyncStreamProvider.class, provider.getClass());
                newContracts.put(AsyncStreamProvider.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncStreamProvider(), e);
            }
        }
        if (Utils.isA(provider, ExceptionMapper.class, contracts)) {
            try {
                this.addExceptionMapper((ExceptionMapper)provider, provider.getClass(), builtIn);
                priority = Utils.getPriority(priorityOverride, contracts, ExceptionMapper.class, provider.getClass());
                newContracts.put(ExceptionMapper.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateExceptionMapper(), e);
            }
        }
    }

    private void addAsyncResponseProvider(AsyncResponseProvider provider, Class providerClass) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface(providerClass, AsyncResponseProvider.class)[0];
        Utils.injectProperties(this.rpf, provider.getClass(), provider);
        Class<?> asyncClass = Types.getRawType(asyncType);
        Map<Class<?>, AsyncResponseProvider> registry = this.getAsyncResponseProvidersForWrite();
        registry.put(asyncClass, provider);
        this.attachedAsyncResponseProviders = false;
        this.asyncResponseProviders = registry;
    }

    private void addAsyncStreamProvider(AsyncStreamProvider provider, Class providerClass) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface(providerClass, AsyncStreamProvider.class)[0];
        Utils.injectProperties(this.rpf, provider.getClass(), provider);
        Class<?> asyncClass = Types.getRawType(asyncType);
        Map<Class<?>, AsyncStreamProvider> registry = this.getAsyncStreamProvidersForWrite();
        registry.put(asyncClass, provider);
        this.attachedAsyncStreamProviders = false;
        this.asyncStreamProviders = registry;
    }

    private void addExceptionMapper(ExceptionMapper provider, Class providerClass, boolean isBuiltin) {
        SortedKey<ExceptionMapper> registeredExceptionMapper;
        if (providerClass.isSynthetic()) {
            providerClass = providerClass.getSuperclass();
        }
        Type exceptionType = Types.getActualTypeArgumentsOfAnInterface(providerClass, ExceptionMapper.class)[0];
        Utils.injectProperties(this.rpf, providerClass, provider);
        Class<?> exceptionClass = Types.getRawType(exceptionType);
        if (!Throwable.class.isAssignableFrom(exceptionClass)) {
            throw new RuntimeException(Messages.MESSAGES.incorrectTypeParameterExceptionMapper());
        }
        int priority = Utils.getPriority(null, null, ExceptionMapper.class, providerClass);
        SortedKey<ExceptionMapper> candidateExceptionMapper = new SortedKey<ExceptionMapper>(null, provider, providerClass, priority, isBuiltin);
        if (this.exceptionMappers != null && (registeredExceptionMapper = this.exceptionMappers.get(exceptionClass)) != null && candidateExceptionMapper.compareTo(registeredExceptionMapper) > 0) {
            return;
        }
        Map<Class<?>, SortedKey<ExceptionMapper>> mappers = this.getExceptionMappersForWrite();
        mappers.put(exceptionClass, candidateExceptionMapper);
        this.attachedExceptionMappers = false;
        this.exceptionMappers = mappers;
    }

    protected JaxrsInterceptorRegistry<ContainerRequestFilter> getRequestFiltersForWrite() {
        if (this.requestFilters == null) {
            return new ContainerRequestFilterRegistryImpl(this.rpf);
        }
        if (this.attachedRequestFilters) {
            return this.requestFilters.clone(this.rpf);
        }
        return this.requestFilters;
    }

    protected JaxrsInterceptorRegistry<ContainerResponseFilter> getResponseFiltersForWrite() {
        if (this.responseFilters == null) {
            return new ContainerResponseFilterRegistryImpl(this.rpf);
        }
        if (this.attachedResponseFilters) {
            return this.responseFilters.clone(this.rpf);
        }
        return this.responseFilters;
    }

    protected Map<Class<?>, AsyncResponseProvider> getAsyncResponseProvidersForWrite() {
        if (this.asyncResponseProviders == null) {
            return new HashMap();
        }
        if (this.lockSnapshots || this.attachedAsyncResponseProviders) {
            return new HashMap(this.asyncResponseProviders);
        }
        return this.asyncResponseProviders;
    }

    protected Map<Class<?>, AsyncStreamProvider> getAsyncStreamProvidersForWrite() {
        if (this.asyncStreamProviders == null) {
            return new HashMap();
        }
        if (this.lockSnapshots || this.attachedAsyncStreamProviders) {
            return new HashMap(this.asyncStreamProviders);
        }
        return this.asyncStreamProviders;
    }

    protected Map<Class<?>, SortedKey<ExceptionMapper>> getExceptionMappersForWrite() {
        if (this.exceptionMappers == null) {
            return new HashMap();
        }
        if (this.lockSnapshots || this.attachedExceptionMappers) {
            return new HashMap(this.exceptionMappers);
        }
        return this.exceptionMappers;
    }

    public JaxrsInterceptorRegistry<ContainerRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    public JaxrsInterceptorRegistry<ContainerResponseFilter> getResponseFilters() {
        return this.responseFilters;
    }

    public Map<Class<?>, AsyncResponseProvider> getAsyncResponseProviders() {
        return this.asyncResponseProviders;
    }

    public Map<Class<?>, AsyncStreamProvider> getAsyncStreamProviders() {
        return this.asyncStreamProviders;
    }

    public Map<Class<?>, SortedKey<ExceptionMapper>> getExceptionMappers() {
        return this.exceptionMappers;
    }
}

