/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.scanner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.Result;

public class ResourceScanner {
    private static final DotName JAKARTA = DotName.createComponentized(null, "jakarta");
    private static final DotName ANNOTATION = DotName.createComponentized(JAKARTA, "annotation");
    private static final DotName PRIORITY = DotName.createComponentized(ANNOTATION, "Priority");
    private static final DotName WS = DotName.createComponentized(JAKARTA, "ws");
    private static final DotName RS = DotName.createComponentized(WS, "rs");
    private static final DotName APPLICATION_PATH = DotName.createComponentized(RS, "ApplicationPath");
    private static final DotName PATH = DotName.createComponentized(RS, "Path");
    private static final DotName CORE = DotName.createComponentized(RS, "core");
    private static final DotName APPLICATION = DotName.createComponentized(CORE, "Application");
    private static final DotName EXT = DotName.createComponentized(RS, "ext");
    private static final DotName PROVIDER = DotName.createComponentized(EXT, "Provider");
    private final IndexView index;
    private final Map<DotName, Set<String>> scanned;

    private ResourceScanner(IndexView index) {
        this.index = index;
        this.scanned = new ConcurrentHashMap<DotName, Set<String>>();
    }

    public static ResourceScanner fromClassPath(ClassLoader cl) throws IOException {
        return ResourceScanner.fromClassPath(cl, null);
    }

    public static ResourceScanner fromClassPath(ClassLoader cl, Predicate<Path> filter) throws IOException {
        String[] cpEntries;
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        Enumeration<URL> resources = cl.getResources("META-INF/jandex.idx");
        if (resources.hasMoreElements()) {
            while (resources.hasMoreElements()) {
                InputStream in = resources.nextElement().openStream();
                try {
                    IndexReader reader = new IndexReader(in);
                    indexes.add(reader.read());
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            return new ResourceScanner(CompositeIndex.create(indexes));
        }
        final Indexer indexer = new Indexer();
        for (String entry : cpEntries = System.getProperty("java.class.path").split(File.pathSeparator)) {
            Path path = Paths.get(entry, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || filter != null && !filter.test(path)) continue;
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().endsWith(".class")) {
                            ResourceScanner.indexClass(indexer, file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            if (path.getFileName().toString().endsWith(".class")) {
                ResourceScanner.indexClass(indexer, path);
                continue;
            }
            if (!path.getFileName().toString().endsWith(".jar")) continue;
            indexes.add(ResourceScanner.indexJar(indexer, path).getIndex());
        }
        indexes.add(indexer.complete());
        return new ResourceScanner(CompositeIndex.create(indexes));
    }

    public static ResourceScanner of(Index index) {
        return new ResourceScanner(index);
    }

    public Set<String> getApplications() {
        Set applications = this.scanned.computeIfAbsent(APPLICATION_PATH, annotation -> {
            ArrayList<ClassInfo> apps = new ArrayList<ClassInfo>();
            apps.addAll(this.resolveTypeFromAnnotation((DotName)annotation));
            apps.addAll(this.index.getAllKnownSubclasses(APPLICATION));
            apps.sort(PrioritySorter.INSTANCE);
            return apps.stream().map(classInfo -> classInfo.name().toString()).collect(Collectors.toSet());
        });
        return Collections.unmodifiableSet(applications);
    }

    public Set<String> getProviders() {
        return this.getTypesAnnotatedWith(PROVIDER);
    }

    public Set<String> getResources() {
        return this.getTypesAnnotatedWith(PATH);
    }

    public Set<String> getTypesAnnotatedWith(DotName annotation) {
        return Collections.unmodifiableSet(this.scanned.computeIfAbsent(annotation, this::resolveFromAnnotation));
    }

    private Set<String> resolveFromAnnotation(DotName annotation) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.resolveTypeFromAnnotation(annotation).forEach(classInfo -> result.add(classInfo.name().toString()));
        return result;
    }

    private Collection<ClassInfo> resolveTypeFromAnnotation(DotName annotation) {
        ArrayList<ClassInfo> results = new ArrayList<ClassInfo>();
        for (AnnotationInstance instance : this.index.getAnnotations(annotation)) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) continue;
            results.add((ClassInfo)target);
        }
        results.sort(PrioritySorter.INSTANCE);
        return results;
    }

    private static Result indexJar(Indexer indexer, Path jar) throws IOException {
        return JarIndexer.createJarIndex(jar.toFile(), indexer, false, false, false);
    }

    private static void indexClass(Indexer indexer, Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            indexer.index(in);
        }
    }

    private static class PrioritySorter
    implements Comparator<ClassInfo> {
        static final PrioritySorter INSTANCE = new PrioritySorter();

        private PrioritySorter() {
        }

        @Override
        public int compare(ClassInfo o1, ClassInfo o2) {
            int p1 = Integer.MAX_VALUE;
            int p2 = Integer.MAX_VALUE;
            AnnotationInstance pa1 = o1.declaredAnnotation(PRIORITY);
            AnnotationInstance pa2 = o2.declaredAnnotation(PRIORITY);
            if (pa1 != null) {
                p1 = pa1.value().asInt();
            }
            if (pa2 != null) {
                p2 = pa2.value().asInt();
            }
            return Integer.compare(p1, p2);
        }
    }
}

