/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.jboss.resteasy.specimpl.UnmodifiableMultivaluedMap;
import org.jboss.resteasy.util.CookieParser;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.HeaderHelper;
import org.jboss.resteasy.util.LocaleHelper;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class ResteasyHttpHeaders
implements HttpHeaders {
    private static final List<MediaType> MEDIA_WILDCARD = List.of(MediaType.WILDCARD_TYPE);
    private static final List<Locale> LANGUAGE_WILDCARD = List.of(Locale.ROOT);
    private static final Map<String, List<MediaType>> mediaTypeCache = Map.ofEntries(Map.entry(MediaType.APPLICATION_ATOM_XML_TYPE.toString(), List.of(MediaType.APPLICATION_ATOM_XML_TYPE)), Map.entry(MediaType.APPLICATION_FORM_URLENCODED_TYPE.toString(), List.of(MediaType.APPLICATION_FORM_URLENCODED_TYPE)), Map.entry(MediaType.APPLICATION_JSON_PATCH_JSON_TYPE.toString(), List.of(MediaType.APPLICATION_JSON_PATCH_JSON_TYPE)), Map.entry(MediaType.APPLICATION_JSON_TYPE.toString(), List.of(MediaType.APPLICATION_JSON_TYPE)), Map.entry(MediaType.APPLICATION_OCTET_STREAM_TYPE.toString(), List.of(MediaType.APPLICATION_OCTET_STREAM_TYPE)), Map.entry(MediaType.APPLICATION_SVG_XML_TYPE.toString(), List.of(MediaType.APPLICATION_SVG_XML_TYPE)), Map.entry(MediaType.APPLICATION_XHTML_XML_TYPE.toString(), List.of(MediaType.APPLICATION_XHTML_XML_TYPE)), Map.entry(MediaType.APPLICATION_XML_TYPE.toString(), List.of(MediaType.APPLICATION_XML_TYPE)), Map.entry(MediaType.MULTIPART_FORM_DATA_TYPE.toString(), List.of(MediaType.MULTIPART_FORM_DATA_TYPE)), Map.entry(MediaType.SERVER_SENT_EVENTS_TYPE.toString(), List.of(MediaType.SERVER_SENT_EVENTS_TYPE)), Map.entry(MediaType.TEXT_HTML_TYPE.toString(), List.of(MediaType.TEXT_HTML_TYPE)), Map.entry(MediaType.TEXT_PLAIN_TYPE.toString(), List.of(MediaType.TEXT_PLAIN_TYPE)), Map.entry(MediaType.TEXT_XML_TYPE.toString(), List.of(MediaType.TEXT_XML_TYPE)), Map.entry(MediaType.WILDCARD_TYPE.toString(), MEDIA_WILDCARD));
    private static final Map<String, List<Locale>> languageCache = Map.ofEntries(Map.entry(Locale.CHINESE.toString(), List.of(Locale.CHINESE)), Map.entry(Locale.ENGLISH.toString(), List.of(Locale.ENGLISH)), Map.entry(Locale.FRENCH.toString(), List.of(Locale.FRENCH)), Map.entry(Locale.GERMAN.toString(), List.of(Locale.GERMAN)), Map.entry(Locale.ITALIAN.toString(), List.of(Locale.ITALIAN)), Map.entry(Locale.JAPANESE.toString(), List.of(Locale.JAPANESE)), Map.entry(Locale.KOREAN.toString(), List.of(Locale.KOREAN)), Map.entry(Locale.SIMPLIFIED_CHINESE.toString(), List.of(Locale.SIMPLIFIED_CHINESE)), Map.entry(Locale.TRADITIONAL_CHINESE.toString(), List.of(Locale.TRADITIONAL_CHINESE)), Map.entry("", LANGUAGE_WILDCARD));
    private final MultivaluedMap<String, String> requestHeaders;
    private final MultivaluedMap<String, String> unmodifiableRequestHeaders;
    private Map<String, Cookie> cookies;
    private String cachedMediaTypeString;
    private MediaType cachedMediaType;

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders) {
        this(requestHeaders, new HashMap<String, Cookie>());
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, boolean eagerlyInitializeEntrySet) {
        this(requestHeaders, new HashMap<String, Cookie>(), eagerlyInitializeEntrySet);
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, Map<String, Cookie> cookies) {
        this(requestHeaders, cookies, true);
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, Map<String, Cookie> cookies, boolean eagerlyInitializeEntrySet) {
        this.requestHeaders = requestHeaders;
        this.unmodifiableRequestHeaders = new UnmodifiableMultivaluedMap<String, String>(requestHeaders, eagerlyInitializeEntrySet);
        this.cookies = cookies == null ? new HashMap() : cookies;
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.unmodifiableRequestHeaders;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.requestHeaders;
    }

    public void testParsing() {
        this.getAcceptableMediaTypes();
        this.getMediaType();
        this.getLanguage();
        this.getAcceptableLanguages();
    }

    @Override
    public List<String> getRequestHeader(String name) {
        List vals = (List)this.unmodifiableRequestHeaders.get(name);
        return vals == null ? Collections.emptyList() : vals;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        this.mergeCookies();
        return Collections.unmodifiableMap(this.cookies);
    }

    public Map<String, Cookie> getMutableCookies() {
        this.mergeCookies();
        return this.cookies;
    }

    public void setCookies(Map<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    @Override
    public Date getDate() {
        String date = this.requestHeaders.getFirst("Date");
        if (date == null) {
            return null;
        }
        return DateUtil.parseDate(date);
    }

    @Override
    public String getHeaderString(String name) {
        List vals = (List)this.requestHeaders.get(name);
        if (vals == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String val : vals) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(val);
        }
        return builder.toString();
    }

    @Override
    public boolean containsHeaderString(String name, Predicate<String> valuePredicate) {
        return this.containsHeaderString(name, ",", valuePredicate);
    }

    @Override
    public boolean containsHeaderString(String name, String valueSeparatorRegex, Predicate<String> valuePredicate) {
        return HeaderHelper.containsHeaderString(this.getHeaderString(name), valueSeparatorRegex, valuePredicate);
    }

    @Override
    public Locale getLanguage() {
        String obj = this.requestHeaders.getFirst("Content-Language");
        if (obj == null) {
            return null;
        }
        return LocaleHelper.extractLocale(obj);
    }

    @Override
    public int getLength() {
        String obj = this.requestHeaders.getFirst("Content-Length");
        if (obj == null) {
            return -1;
        }
        return Integer.parseInt(obj);
    }

    @Override
    public MediaType getMediaType() {
        String obj = this.requestHeaders.getFirst("Content-Type");
        if (obj == null) {
            return null;
        }
        if (obj == this.cachedMediaTypeString) {
            return this.cachedMediaType;
        }
        this.cachedMediaTypeString = obj;
        this.cachedMediaType = MediaType.valueOf(obj);
        return this.cachedMediaType;
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        List vals = (List)this.requestHeaders.get("Accept");
        if (vals == null || vals.isEmpty()) {
            return MEDIA_WILDCARD;
        }
        if (vals.size() == 1) {
            String type = ((String)vals.get(0)).trim();
            if ("*/*".equals(type)) {
                return MEDIA_WILDCARD;
            }
            List<MediaType> standard = mediaTypeCache.get(type);
            if (standard != null) {
                return standard;
            }
        }
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        for (String v : vals) {
            StringTokenizer tokenizer = new StringTokenizer(v, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                list.add(MediaType.valueOf(item));
            }
        }
        MediaTypeHelper.sortByWeight(list);
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        List vals = (List)this.requestHeaders.get("Accept-Language");
        if (vals == null || vals.isEmpty()) {
            return LANGUAGE_WILDCARD;
        }
        if (vals.size() == 1) {
            String type = (String)vals.get(0);
            if (type.isBlank()) {
                return LANGUAGE_WILDCARD;
            }
            List<Locale> standard = languageCache.get(type);
            if (standard != null) {
                return standard;
            }
        }
        ArrayList<WeightedLanguage> languages = new ArrayList<WeightedLanguage>();
        for (String v : vals) {
            StringTokenizer tokenizer = new StringTokenizer(v, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                languages.add(WeightedLanguage.parse(item));
            }
        }
        Collections.sort(languages);
        ArrayList<Locale> list = new ArrayList<Locale>(languages.size());
        for (WeightedLanguage language : languages) {
            list.add(language.getLocale());
        }
        return Collections.unmodifiableList(list);
    }

    private void mergeCookies() {
        List cookieHeader = (List)this.requestHeaders.get("Cookie");
        if (cookieHeader != null && !cookieHeader.isEmpty()) {
            for (String s : cookieHeader) {
                List<Cookie> list = CookieParser.parseCookies(s);
                for (Cookie cookie : list) {
                    this.cookies.put(cookie.getName(), cookie);
                }
            }
        }
    }
}

